<?php
require_once("../layouts/members/head.php");
if ($user_data['ration_to_pdf_Service'] == "YES") {
if (in_array($user_data['usertype'], ['Master Distributor', 'Distributor', 'Retailer'])) {
?>
<div class="row">
    <div class="col-md-4 mb-2">
      <div class="card text-danger">
        <div class="card-header bg-primary text-white py-2">
          <div class="d-flex align-items-center">
            <span class="mr-auto"><?= file_name() ?></span>
             <button class="btn btn-dark btn-sm ml-auto" onclick="history.back()" > <i class="fas fa-arrow-left"></i> Back</button>
          </div>
        </div>
        <div class="p-3 text-dark">
          <?php
          $apiResponseData = null;
          $response = []; // Initialize

          if (isset($_POST['submit'])) {
              $rationNumber = strtoupper($_POST['rationNumber']);

              if (!empty($rationNumber)) {
                  $amount = $user_data['ration_pdf_fee'];
                  $old_balance = $user_data['balance'];
                  $new_balance = $old_balance - $amount;

                  if ($user_data['balance'] >= $amount) {
                      $order_id = order_txn_id();
                      
                      // --- NEW API IMPLEMENTATION START ---
                      $apiKey = "APIKEYPASTEE"; // Buy APi From This Website https://apizone.co.in ( Design & Development By APIZONE )
                      $apiUrl = "https://kycapizone.in/api/v2/ration/ration.php?api_key=" . $apiKey . "&ration_number=" . $rationNumber . "&type=1";

                      $curl = curl_init();
                      curl_setopt_array($curl, array(
                         CURLOPT_URL => $apiUrl,
                         CURLOPT_RETURNTRANSFER => true,
                         CURLOPT_ENCODING => '',
                         CURLOPT_MAXREDIRS => 10,
                         CURLOPT_TIMEOUT => 30,
                         CURLOPT_FOLLOWLOCATION => true,
                         CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                         CURLOPT_CUSTOMREQUEST => 'GET',
                         CURLOPT_SSL_VERIFYPEER => false,
                      ));

                      $responseApi = curl_exec($curl);
                      curl_close($curl);
                      
                      $json_data = json_decode($responseApi, true) ?? [];

                      if (isset($json_data['status']) && $json_data['status'] == '100') {
                          
                          $apiResult = $json_data['result']['result'] ?? []; // Access nested result object
                          
                          $response['status'] = '100';
                          $response['rcId'] = $apiResult['rcId'] ?? $rationNumber;
                          $response['homeStateName'] = $apiResult['state'] ?? 'NA';
                          $response['address'] = $apiResult['full_address'] ?? 'NA';
                          $response['fpsId'] = $apiResult['fpsId'] ?? 'NA';
                          $response['pdf_base64'] = $apiResult['pdf_file'] ?? '';

                          // Set empty defaults for fields not provided by new API
                          $response['homeStateCode'] = 'NA';
                          $response['districtCode'] = 'NA';
                          $response['homeDistName'] = 'NA'; // Dist name not separated in new API
                          $response['schemeName'] = 'NA';
                          $response['memberDetailsList'] = [];

                          $updateSuccess = db_update("members", ["balance" => $new_balance], " user_id='" . $user_data['user_id'] . "' ");

                          if ($updateSuccess) {
                              $printData = array(
                                  'rcId' => $response['rcId'],
                                  'homeStateCode' => $response['homeStateCode'],
                                  'districtCode' => $response['districtCode'],
                                  'homeStateName' => $response['homeStateName'],
                                  'homeDistName' => $response['homeDistName'],
                                  'address' => $response['address'],
                                  'fpsId' => $response['fpsId'],
                                  'schemeName' => $response['schemeName'],
                                  'memberDetailsList' => $response['memberDetailsList'],
                                  'username'      => $user_data['username'],
                                  'pdf_data' => $response['pdf_base64']
                              );
                              
                              $name = $response['rcId']; // Using Ration No as name since API doesn't return owner name explicitly here

                               $Mremark = 'Ration Number: ' . $rationNumber;
                               $insData = [
                                   'order_id'       => $order_id,
                                   'username'       => $user_data['username'],
                                   'name'           => $name,
                                   'idNumber'       => $rationNumber,
                                   'service'        => "RATIONPDF",
                                   'date_time'      => current_timestamp(),
                                   'printData'      => base64_encode(str_replace("\\", "", json_encode($printData, JSON_UNESCAPED_UNICODE))),
                                   'photo'          => "",
                               ];

                               $insertIddata = db_insert("printRecords", $insData);
    
                               if ($insertIddata) {
                              $insData = [
                                  'site_id'       => $site_data['site_id'],
                                  'user_id'       => $user_data['user_id'],
                                  'username'      => $user_data['username'],
                                  'name'          => $user_data['name'],
                                  'operator'      => $user_data['usertype'],
                                  'parent_id'     => $user_data['parent_id'],
                                  'order_id'      => $order_id,
                                  'service'       => "RATIONPDF",
                                  'type'          => "Debit",
                                  'account_number'=> $response['rcId'],
                                  'app_type'      => "RATIONPDF",
                                  'amount'        => $amount,
                                  'main_amount'   => $amount,
                                  'old_balance'   => $old_balance,
                                  'new_balance'   => $new_balance,
                                  'txn_id'        => $order_id,
                                  'ref_id'        => $response['rcId'],
                                  'description'   => "Rs.{$amount} Has Been Debit From Wallet for Ration Number {$rationNumber}",
                                  'date_time'     => current_timestamp(),
                                  'status'        => "Success"
                              ];

                              $insertId = db_insert("reports", $insData);
                              if ($insertId) {
                                  $fields = [
                                      'rcId' => 'RATION No',
                                      'address' => 'Address',
                                  ];

                                  $whamessage = "Dear {$user_data['name']},\nYour Request for Ration Number *{$rationNumber}* Verification has been Complete.\n\n";

                                  foreach ($fields as $key => $label) {
                                      if (!empty($response[$key])) {
                                          $whamessage .= "*$label*: {$response[$key]}\n";
                                      }
                                  }
                                  $whamessage .= "\nBest Regards,\n_*{$site_data['brand']}.*_";
                                   send_sms($user_data['mobile'],$whamessage);
                              } else {
                                  awal_alert_msg("Insert Server Error!", 'error');
                              }
                              awal_alert_msg("Data Fetch Successful from '.$Mremark.'.", 'success');
                                echo "<script>setTimeout(function(){ window.location.href='printRecord'; }, 3000);</script>";
                            } else {
                                 awal_alert_msg("Saving Data Error!", 'error');
                             }
                          } else {
                              awal_alert_msg("Balance debited from wallet but not updated in the database. Please contact support!", 'error');
                          }
                      } else {
                          $msg = $json_data['message'] ?? 'Server Down or Data Not Found';
                          awal_alert_msg($msg, 'error');
                      }
                      // --- NEW API IMPLEMENTATION END ---
                      
                  } else {
                      awal_alert_msg("Insufficient Wallet Balance!", 'error');
                  }
              } else {
                  awal_alert_msg("Please Fill All Valid Details!", 'error');
              }
          }
          ?>
          <form action="" method="POST" class="row">
            <div class="col-md-12 mb-3">
              <label>Ration Number</label>
              <input type="number" name="rationNumber" placeholder="Enter Ration Number" maxlength="25" oninput="this.value = this.value.toUpperCase().replace(/\s+/g, '');" class="form-control" onkeypress="if(this.value.length==45) return false;" required>
            </div>
            <div class="col-md-12 mb-3 d-flex justify-content-between">
              <button type="button" class="btn btn-secondary" ><i class="fas fa-inr"></i> <?php echo $user_data['ration_pdf_fee'];?></button>
              <button type="submit" name="submit" class="btn btn-primary" onclick="return confirm('Are you sure?');">Submit</button>
              <button type="button" class="btn btn-warning" data-toggle="modal" data-target="#showDetailsModal">Show</button>
            </div>
          </form>
        </div>
      </div>
    </div>
</div>

<div class="modal fade" id="showDetailsModal" tabindex="-1" role="dialog" aria-labelledby="showDetailsModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="showDetailsModalLabel">Fetched Details</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
    <?php if (isset($response['rcId']) && !empty($response['rcId'])) { ?>
          <form class="row">
            <div class="col-md-6 mb-3">
              <label>Ration Number</label>
              <input type="text" value="<?= htmlspecialchars($response['rcId']) ?>" class="form-control" readonly>
            </div>
            <div class="col-md-6 mb-3">
              <label>State</label>
              <input type="text" value="<?= htmlspecialchars($response['homeStateName']) ?>" class="form-control" readonly>
              </div>
          </form>
        <?php } else { ?>
          <p>No details fetched yet. Submit Ration Number to Download PDF.</p>
        <?php } ?>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<script>
  <?php if (isset($response['rcId']) && !empty($response['rcId'])) { ?>
    $(document).ready(function() {
      $('#showDetailsModal').modal('show');
    });
  <?php } ?>
</script>

<?php
} else {
    require_once("404.php");
}
} else {
      awal_alert_msg('You Do Not Have Any Ration Service Active!', 'info', 'dashboard');
}
require_once("../layouts/members/foot.php");
?>